<?php
/**
 * My Account - Coffee Subscriptions
 *
 * Customer subscription management page template
 *
 * @package YourBeans_Coffee
 */

defined('ABSPATH') || exit;

$subscriptions = isset($subscriptions) ? $subscriptions : array();
?>

<div class="yourbeans-my-subscriptions">
    <h2><?php esc_html_e('My Coffee Subscriptions', 'yourbeans-coffee'); ?></h2>

    <?php if (empty($subscriptions)): ?>
        <div class="woocommerce-message woocommerce-message--info">
            <?php esc_html_e('You do not have any active coffee subscriptions.', 'yourbeans-coffee'); ?>
        </div>
        <p>
            <a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>" class="button">
                <?php esc_html_e('Browse Products', 'yourbeans-coffee'); ?>
            </a>
        </p>
    <?php else: ?>
        <table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
            <thead>
                <tr>
                    <th class="woocommerce-orders-table__header"><?php esc_html_e('Product', 'yourbeans-coffee'); ?></th>
                    <th class="woocommerce-orders-table__header"><?php esc_html_e('Frequency', 'yourbeans-coffee'); ?></th>
                    <th class="woocommerce-orders-table__header"><?php esc_html_e('Next Delivery', 'yourbeans-coffee'); ?></th>
                    <th class="woocommerce-orders-table__header"><?php esc_html_e('Status', 'yourbeans-coffee'); ?></th>
                    <th class="woocommerce-orders-table__header"><?php esc_html_e('Actions', 'yourbeans-coffee'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($subscriptions as $subscription): ?>
                    <?php
                    $product = wc_get_product($subscription['variation_id'] ? $subscription['variation_id'] : $subscription['product_id']);
                    $product_name = $product ? $product->get_name() : __('Product not found', 'yourbeans-coffee');

                    $intervals = yourbeans()->subscriptions->get_intervals();
                    $interval_label = isset($intervals[$subscription['interval']]['label'])
                        ? $intervals[$subscription['interval']]['label']
                        : ucfirst($subscription['interval']);

                    $next_renewal = $subscription['next_renewal']
                        ? date_i18n(get_option('date_format'), strtotime($subscription['next_renewal']))
                        : '-';

                    $status_labels = array(
                        'active' => __('Active', 'yourbeans-coffee'),
                        'paused' => __('Paused', 'yourbeans-coffee'),
                        'cancelled' => __('Cancelled', 'yourbeans-coffee'),
                    );
                    $status_label = isset($status_labels[$subscription['status']])
                        ? $status_labels[$subscription['status']]
                        : ucfirst($subscription['status']);

                    $status_class = 'yourbeans-status-' . esc_attr($subscription['status']);
                    ?>
                    <tr class="woocommerce-orders-table__row" data-subscription-id="<?php echo esc_attr($subscription['id']); ?>">
                        <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Product', 'yourbeans-coffee'); ?>">
                            <?php if ($product): ?>
                                <a href="<?php echo esc_url($product->get_permalink()); ?>">
                                    <?php echo esc_html($product_name); ?>
                                </a>
                            <?php else: ?>
                                <?php echo esc_html($product_name); ?>
                            <?php endif; ?>
                            <br>
                            <small class="subscription-quantity">
                                <?php
                                printf(
                                    esc_html__('Qty: %d', 'yourbeans-coffee'),
                                    $subscription['quantity']
                                );
                                ?>
                            </small>
                        </td>
                        <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Frequency', 'yourbeans-coffee'); ?>">
                            <?php echo esc_html($interval_label); ?>
                            <?php if ($subscription['discount'] > 0): ?>
                                <br>
                                <small class="subscription-discount">
                                    <?php
                                    printf(
                                        esc_html__('%d%% off', 'yourbeans-coffee'),
                                        $subscription['discount']
                                    );
                                    ?>
                                </small>
                            <?php endif; ?>
                        </td>
                        <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Next Delivery', 'yourbeans-coffee'); ?>">
                            <?php if ($subscription['status'] === 'active'): ?>
                                <?php echo esc_html($next_renewal); ?>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Status', 'yourbeans-coffee'); ?>">
                            <span class="yourbeans-subscription-status <?php echo esc_attr($status_class); ?>">
                                <?php echo esc_html($status_label); ?>
                            </span>
                        </td>
                        <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Actions', 'yourbeans-coffee'); ?>">
                            <?php if ($subscription['status'] === 'active'): ?>
                                <button type="button"
                                        class="button button-small yourbeans-pause-subscription"
                                        data-subscription-id="<?php echo esc_attr($subscription['id']); ?>">
                                    <?php esc_html_e('Pause', 'yourbeans-coffee'); ?>
                                </button>
                                <button type="button"
                                        class="button button-small yourbeans-cancel-subscription"
                                        data-subscription-id="<?php echo esc_attr($subscription['id']); ?>">
                                    <?php esc_html_e('Cancel', 'yourbeans-coffee'); ?>
                                </button>
                            <?php elseif ($subscription['status'] === 'paused'): ?>
                                <button type="button"
                                        class="button button-small yourbeans-resume-subscription"
                                        data-subscription-id="<?php echo esc_attr($subscription['id']); ?>">
                                    <?php esc_html_e('Resume', 'yourbeans-coffee'); ?>
                                </button>
                                <button type="button"
                                        class="button button-small yourbeans-cancel-subscription"
                                        data-subscription-id="<?php echo esc_attr($subscription['id']); ?>">
                                    <?php esc_html_e('Cancel', 'yourbeans-coffee'); ?>
                                </button>
                            <?php else: ?>
                                <span class="yourbeans-subscription-ended">
                                    <?php esc_html_e('Ended', 'yourbeans-coffee'); ?>
                                </span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<style>
.yourbeans-my-subscriptions .subscription-quantity,
.yourbeans-my-subscriptions .subscription-discount {
    color: #666;
}

.yourbeans-subscription-status {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 3px;
    font-size: 12px;
    font-weight: 600;
}

.yourbeans-status-active {
    background: #d4edda;
    color: #155724;
}

.yourbeans-status-paused {
    background: #fff3cd;
    color: #856404;
}

.yourbeans-status-cancelled {
    background: #f8d7da;
    color: #721c24;
}

.yourbeans-subscription-ended {
    color: #999;
    font-style: italic;
}

.yourbeans-my-subscriptions .button-small {
    padding: 4px 10px;
    font-size: 12px;
    margin-right: 5px;
}

.yourbeans-my-subscriptions .button-small:last-child {
    margin-right: 0;
}

@media screen and (max-width: 768px) {
    .yourbeans-my-subscriptions .button-small {
        display: block;
        margin-bottom: 5px;
        margin-right: 0;
    }
}
</style>
