/**
 * YourBeans Coffee - Subscription Management JavaScript
 */

(function($) {
    'use strict';

    var YourBeansSubscriptions = {
        init: function() {
            this.bindEvents();
        },

        bindEvents: function() {
            // Pause subscription
            $('.yourbeans-pause-subscription').on('click', this.pauseSubscription.bind(this));

            // Resume subscription
            $('.yourbeans-resume-subscription').on('click', this.resumeSubscription.bind(this));

            // Cancel subscription
            $('.yourbeans-cancel-subscription').on('click', this.cancelSubscription.bind(this));
        },

        pauseSubscription: function(e) {
            e.preventDefault();

            var $button = $(e.target);
            var subscriptionId = $button.data('subscription-id');

            if (!confirm(yourbeansSubscriptions.strings.confirm_pause)) {
                return;
            }

            this.sendRequest('yourbeans_pause_subscription', subscriptionId, $button);
        },

        resumeSubscription: function(e) {
            e.preventDefault();

            var $button = $(e.target);
            var subscriptionId = $button.data('subscription-id');

            this.sendRequest('yourbeans_resume_subscription', subscriptionId, $button);
        },

        cancelSubscription: function(e) {
            e.preventDefault();

            var $button = $(e.target);
            var subscriptionId = $button.data('subscription-id');

            if (!confirm(yourbeansSubscriptions.strings.confirm_cancel)) {
                return;
            }

            this.sendRequest('yourbeans_cancel_subscription', subscriptionId, $button);
        },

        sendRequest: function(action, subscriptionId, $button) {
            var self = this;

            $button.prop('disabled', true).addClass('loading');

            $.ajax({
                url: yourbeansSubscriptions.ajax_url,
                type: 'POST',
                data: {
                    action: action,
                    nonce: yourbeansSubscriptions.nonce,
                    subscription_id: subscriptionId
                },
                success: function(response) {
                    if (response.success) {
                        // Reload page to show updated status
                        location.reload();
                    } else {
                        alert(response.data.message || 'An error occurred. Please try again.');
                        $button.prop('disabled', false).removeClass('loading');
                    }
                },
                error: function() {
                    alert('Connection error. Please try again.');
                    $button.prop('disabled', false).removeClass('loading');
                }
            });
        }
    };

    $(document).ready(function() {
        YourBeansSubscriptions.init();
    });

})(jQuery);
