# YourBeans Coffee - WordPress/WooCommerce Plugin

**Premium coffee dropshipping integration for WooCommerce stores**
*By MyShop Enterprises Pty Ltd*

---

## Overview

YourBeans Coffee connects your WooCommerce store to the MyShop.Coffee platform, enabling seamless product import, automated fulfillment, and real-time payment splitting via Stripe Connect.

### Key Features

- **One-Click Import**: Import products with 12 variants (2 sizes × 6 grind types)
- **Stripe Connect**: Automatic payment splitting at checkout
- **Real-Time Sync**: Hourly inventory synchronization
- **Automated Fulfillment**: Orders sent to MyShop.Coffee automatically
- **Tracking Updates**: Shipping info pushed back to your store

## Requirements

- WordPress 5.8+
- WooCommerce 6.0+
- PHP 7.4+
- Stripe payment gateway
- MyShop.Coffee vendor account

## Installation

1. Download the plugin zip file
2. Go to WordPress Admin → Plugins → Add New → Upload Plugin
3. Upload the zip file and click Install Now
4. Activate the plugin

## Configuration

### 1. Connect to MyShop.Coffee

1. Go to **YourBeans → Settings**
2. Enter your MyShop.Coffee API Key (get this from your vendor dashboard)
3. Click Save Changes

### 2. Connect Stripe

1. On the Settings page, click **Connect Stripe Account**
2. Complete the Stripe Connect OAuth flow
3. Your account will be linked for automatic payment splitting

### 3. Import Products

1. Go to **YourBeans → Import Products**
2. Click **Load Catalog** to browse available products
3. Click **Import** on any product to add it to your store
4. Customize title and markup as needed

## How Payment Splitting Works

When a customer purchases a YourBeans product:

```
Customer pays $50
    ↓
Stripe Connect automatically splits:
    → MyShop.Coffee receives: COGS + shipping + platform fee ($25)
    → You keep: Your margin ($25)
```

No prepaid credits or manual settlements needed!

## Frequently Asked Questions

### What products can I import?

All products from the MyShop.Coffee premium coffee catalog are available for import.

### How often does inventory sync?

Inventory levels sync automatically every hour. You can also trigger a manual sync from the dashboard.

### What happens when an order is placed?

1. Customer completes checkout
2. Payment is split automatically via Stripe Connect
3. Order is submitted to MyShop.Coffee for fulfillment
4. You receive tracking info when the order ships

### Can I customize product prices?

Yes! Set a default markup percentage in Settings, or customize the markup for each product during import.

## Support

- Email: support@myshop.coffee
- Documentation: https://myshop.coffee/docs/wordpress-plugin

## Changelog

### 1.0.0
- Initial release
- Product import with 12 variants
- Stripe Connect integration
- Order submission and tracking

---

Built with care by MyShop.Coffee Team
